# E-Szperanto - AI-Powered Search engine for Magento

E-Szperanto is a Magento plugin designed to revolutionize the way products are discovered in your e-commerce store. Utilizing advanced AI algorithms, E-Szperanto automatically tags images with accurate and relevant keywords, enhancing search functionality and user experience.

## Features

- **AI-Powered Image Tagging**: Automatically tags product images with relevant keywords using AI.
- **Enhanced Search Functionality**: Improves the search engine within Magento to recognize and return results based on image content.
- **Easy Integration**: Seamlessly integrates with Magento, enhancing existing search without the need for complex configuration.
- **User Experience Improvement**: Helps customers find exactly what they're looking for, quickly and efficiently.

## Installation

1. **Download the Plugin**
   - Download the latest version of E-Szperanto from the Magento Marketplace.

2. **Install via Composer**
   - Run the following command in your Magento root directory:
     ```bash
     composer require vendorname/e-szperanto
     ```

3. **Enable the Plugin**
   - Enable the plugin and clear static content:
     ```bash
     bin/magento module:enable VendorName_Eszperanto
     bin/magento setup:upgrade
     bin/magento cache:clean
     bin/magento setup:static-content:deploy
     ```

## Configuration

1. **Navigate to Plugin Settings**
   - In your Magento admin panel, go to `Stores` > `Configuration` > `VendorName` > `E-Szperanto Configuration`.

2. **API Settings**
   - Enter your E-Szperanto API credentials. These are required for the AI image tagging service.

3. **Image Tagging Options**
   - Customize how E-Szperanto tags your images, including frequency and tag specificity.

## Usage

- Once installed and configured, E-Szperanto automatically begins processing and tagging new product images.
- Existing images can be tagged by initiating a bulk operation from the plugin settings page.

## License

E-Szperanto is open-source software released under the [Open Software License (OSL 3.0)](#).
